/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.gui.screens.GameScreen;
import org.figuramc.figura.gui.widgets.ContextMenu;
import org.figuramc.figura.gui.widgets.FiguraRemovable;
import org.figuramc.figura.gui.widgets.FiguraTickable;
import org.figuramc.figura.gui.widgets.PanelSelectorWidget;
import org.figuramc.figura.lua.api.ClientAPI;
import org.figuramc.figura.mixin.gui.ScreenAccessor;
import org.figuramc.figura.utils.FiguraIdentifier;
import org.figuramc.figura.utils.ui.UIHelper;

public abstract class AbstractPanelScreen
extends Screen {
    public static final List<ResourceLocation> BACKGROUNDS = List.of(new FiguraIdentifier("textures/gui/background/background_0.png"), new FiguraIdentifier("textures/gui/background/background_1.png"), new FiguraIdentifier("textures/gui/background/background_2.png"));
    protected final Screen parentScreen;
    public PanelSelectorWidget panels;
    public ContextMenu contextMenu;
    public Component tooltip;
    private static final String EGG = "\u0109\u0109\u0108\u0108\u0107\u0106\u0107\u0106BA\u0101";
    private String egg = "\u0109\u0109\u0108\u0108\u0107\u0106\u0107\u0106BA\u0101";

    protected AbstractPanelScreen(Screen parentScreen, Component title) {
        super(title);
        this.parentScreen = parentScreen;
    }

    public Class<? extends Screen> getSelectedPanel() {
        return ((Object)((Object)this)).getClass();
    }

    protected void init() {
        super.init();
        this.panels = new PanelSelectorWidget(this.parentScreen, 0, 0, this.width, this.getSelectedPanel());
        this.addRenderableWidget((GuiEventListener)this.panels);
        this.contextMenu = null;
        this.tooltip = null;
    }

    public void tick() {
        for (Renderable renderable : this.renderables()) {
            if (!(renderable instanceof FiguraTickable)) continue;
            FiguraTickable tickable = (FiguraTickable)renderable;
            tickable.tick();
        }
        this.renderables().removeIf(r -> {
            FiguraRemovable removable;
            return r instanceof FiguraRemovable && (removable = (FiguraRemovable)r).isRemoved();
        });
        super.tick();
    }

    public List<Renderable> renderables() {
        return ((ScreenAccessor)((Object)this)).getRenderables();
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        this.renderBackground(gui, delta);
        super.render(gui, mouseX, mouseY, delta);
        this.renderOverlays(gui, mouseX, mouseY, delta);
    }

    public void renderBackground(GuiGraphics gui, float delta) {
        float speed = ((Float)Configs.BACKGROUND_SCROLL_SPEED.tempValue).floatValue() * 0.125f;
        for (ResourceLocation background : BACKGROUNDS) {
            UIHelper.renderAnimatedBackground(gui, background, 0.0f, 0.0f, this.width, this.height, 64.0f, 64.0f, speed, delta);
            speed = (float)((double)speed / 0.5);
        }
    }

    public void renderOverlays(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (((Boolean)Configs.GUI_FPS.value).booleanValue()) {
            gui.drawString(Minecraft.getInstance().font, ClientAPI.getFPS() + " fps", 1, 1, 0xFFFFFF);
        }
        if (this.contextMenu != null && this.contextMenu.isVisible()) {
            PoseStack pose = gui.pose();
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 500.0f);
            this.contextMenu.render(gui, mouseX, mouseY, delta);
            pose.popPose();
        }
        if (this.tooltip != null) {
            UIHelper.renderTooltip(gui, this.tooltip, mouseX, mouseY, true);
        }
        this.tooltip = null;
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.contextMenuClick(mouseX, mouseY, button)) {
            return true;
        }
        GuiEventListener widget = null;
        for (GuiEventListener children : List.copyOf(this.children())) {
            boolean clicked = children.mouseClicked(mouseX, mouseY, button);
            children.setFocused(clicked);
            if (!clicked) continue;
            widget = children;
        }
        if (this.getFocused() != widget) {
            this.setFocused(widget);
        }
        if (widget != null) {
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean contextMenuClick(double mouseX, double mouseY, int button) {
        if (this.contextMenu != null && this.contextMenu.isVisible()) {
            boolean clicked = this.contextMenu.mouseClicked(mouseX, mouseY, button);
            if (!clicked && this.contextMenu.parent != null && this.contextMenu.parent.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            this.contextMenu.setVisible(false);
            return clicked;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.getFocused() != null && this.getFocused().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        boolean bool;
        boolean bl = bool = this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
        if (bool) {
            this.setFocused(null);
        }
        this.setDragging(false);
        return bool;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount, double d) {
        if (this.contextMenu != null) {
            this.contextMenu.setVisible(false);
        }
        boolean ret = false;
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY)) continue;
            ret = ret || child.mouseScrolled(mouseX, mouseY, amount, d);
        }
        return ret;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.egg = this.egg + (char)keyCode;
        this.egg = this.egg.substring(1);
        if (EGG.equals(this.egg)) {
            Minecraft.getInstance().setScreen((Screen)new GameScreen(this));
            return true;
        }
        if (this.children().contains(this.panels) && this.panels.cycleTab(keyCode)) {
            return true;
        }
        if (keyCode == 256 && this.contextMenu != null && this.contextMenu.isVisible()) {
            this.contextMenu.setVisible(false);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void renderBlurredBackground(float tickDelta) {
    }
}

